<?php
 
include_once 'conexao.php';
 
class ModeloBiblioteca 
{      
	static public function mdlAddBiblioteca($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO biblioteca(nomeArquivo, breveDescricao, preco, tipoArquivo, localArquivo, idUsuario, dataCadastro, estilo, autor, ano, capa) VALUES (:nomeArquivo,:breveDescricao, :preco, :tipoArquivo,:localArquivo,:idUsuario,:dataCadastro,:estilo,:autor,:ano, :capa)");
 
		$stmt->bindParam(":nomeArquivo", $dados["nomeArquivo"], PDO::PARAM_STR);
		$stmt->bindParam(":breveDescricao", $dados["breveDescricao"], PDO::PARAM_STR);
		$stmt->bindParam(":preco", $dados["preco"], PDO::PARAM_STR);
		$stmt->bindParam(":tipoArquivo", $dados["tipoArquivo"], PDO::PARAM_STR);
		$stmt->bindParam(":estilo", $dados["estilo"], PDO::PARAM_STR);
		$stmt->bindParam(":autor", $dados["autor"], PDO::PARAM_STR);
		$stmt->bindParam(":ano", $dados["ano"], PDO::PARAM_STR);
		$stmt->bindParam(":localArquivo", $dados["localArquivo"], PDO::PARAM_STR);
		$stmt->bindParam(":capa", $dados["capa"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $dados["idUsuario"], PDO::PARAM_STR);
		
		
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}
  
	static public function mdlMostrarArquivosDaBibliotecaPorIdBiblioteca($idBiblioteca) {

		$resultado = array();   

			$stmt = Conexao::conectar()->prepare("SELECT * FROM biblioteca where idBiblioteca = :idBiblioteca");
			$stmt->bindParam(":idBiblioteca", $idBiblioteca, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarArquivosDaBibliotecaPorNome($nomeArquivo) {

		$resultado = array();
		$stmt = Conexao::conectar()->prepare("SELECT * FROM biblioteca where nomeArquivo = :nomeArquivo");
		$stmt->bindParam(":nomeArquivo", $nomeArquivo, PDO::PARAM_STR);
		$stmt ->execute();
		
		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlMostrarTodosArquivosNaBiblioteca() {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM biblioteca");
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarArquivosNaBibliotecaComLimite($limite) {
		$resultado = array();
	
		// Modifique a consulta SQL para ordenar por ordem decrescente e aplicar o limite
		$stmt = Conexao::conectar()->prepare("SELECT * FROM biblioteca ORDER BY idBiblioteca DESC LIMIT :limite");
		$stmt->bindParam(':limite', $limite, PDO::PARAM_INT);
		$stmt->execute();
	
		$resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}
 
	static public function mdlMostrarArquivoBibliotecaPeloNomeArquivoEIdUsurario($nomeArquivo, $idUsuario) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM biblioteca where nomeArquivo = :nomeArquivo and idUsuario = :idUsuario");
		$stmt->bindParam(":nomeArquivo", $nomeArquivo, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlMostrarArquivosNaBibliotecaPorIdUsurario($idUsuario) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM biblioteca where idUsuario = :idUsuario");
			$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarVagasPorCategoriaDaVaga($tipoVaga) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where tipoVaga = :tipoVaga");
			$stmt->bindParam(":tipoVaga", $tipoVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlActualizarCapaArquivoBiblioteca($idBiblioteca, $capa) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("UPDATE biblioteca SET capa = :capa where idBiblioteca = :idBiblioteca");
			$stmt->bindParam(":capa", $capa, PDO::PARAM_STR);
			$stmt->bindParam(":idBiblioteca", $idBiblioteca, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodasVagas() {

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga ");
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}



	static public function mdlEliminarLikeDoEventoPorIdLike($id, $idUsuario){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM eventolikes where idEvento = :id and idUsuario = :idUsuario");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>